<?php
require_once __DIR__ . '/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

/* -----------------------------
   DATABASE CONNECTION
------------------------------*/

    
$host = "localhost";
$db   = "admission_delhi";
$user = "admission_delhi_user";   // change if needed
$pass = "5AXobQM;ND0gTVwW";       // change if needed

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die("DB Error");
}


function base64img($path) {
    if (!$path) return "";

    // absolute file path
    $file = __DIR__ . "/" . $path;

    if (!file_exists($file)) return "";

    $type = pathinfo($file, PATHINFO_EXTENSION);
    $data = file_get_contents($file);

    return 'data:image/'.$type.';base64,' . base64_encode($data);
}



/* -----------------------------
   GET RECORD
------------------------------*/

if (!isset($_GET['id'])) {
    die("Invalid Request");
}

$id = intval($_GET['id']);

$stmt = $pdo->prepare("SELECT * FROM applications WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$app = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$app) {
    die("Not Found");
}

/* -----------------------------
   PDF HTML CONTENT
------------------------------*/
$html = '
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">

<style>
body {
    font-family: DejaVu Sans, sans-serif;
    font-size: 12px;
    padding: 10px;
}

.title {
    text-align: center;
    font-size: 22px;
    font-weight: bold;
    margin-bottom: 18px;
    text-transform: uppercase;
}

.section-title {
    background: #f0f0f0;
    border-left: 4px solid #333;
    padding: 6px 10px;
    font-size: 14px;
    font-weight: bold;
    margin-top: 20px;
}

.table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 8px;
}

.table th, .table td {
    border: 1px solid #444;
    padding: 8px;
    vertical-align: top;
}

.photo-box {
    width: 100px;
    height: 120px;
    border: 1px solid #000;
    object-fit: cover;
}

.signature {
    width: 140px;
    height: 60px;
    object-fit: contain;
}

.section-space {
    margin-bottom: 15px;
}
</style>
</head>

<body>

<div style="text-align:center; margin-bottom:20px;">
    <img src="'.base64img("uploads/logo.jpeg").'" 
         style="width:620px; height:auto; margin-bottom:8px;">
    <div style="font-size:22px; font-weight:bold; text-transform:uppercase;">
        Student Admission Form – PDF Copy
    </div>
</div>
<br>
<!-- ================================
         STUDENT PHOTOS
================================= -->
<div class="section-title">Student Photos</div>
<table class="table">
    <tr>
        <td>
            <b>Child Photo</b><br>
            <img class="photo-box" src="'.base64img($app['photo_child']).'">
        </td>
        <td>
            <b>Father Photo</b><br>
            <img class="photo-box" src="'.base64img($app['photo_father']).'">
        </td>
        <td>
            <b>Mother Photo</b><br>
            <img class="photo-box" src="'.base64img($app['photo_mother']).'">
        </td>
    </tr>
</table>



<!-- ================================
         STUDENT INFORMATION
================================= -->
<div class="section-title">Student Information</div>
<table class="table">
    <tr>
        <td><b>Class Sought:</b> '.$app['class_sought'].'</td>
        <td><b>Registration No:</b> '.$app['reg_no'].'</td>
    </tr>
    <tr>
        <td colspan="2"><b>Child Name:</b> '.$app['child_name'].'</td>
    </tr>
    <tr>
        <td><b>Gender:</b> '.$app['gender'].'</td>
        <td><b>Nationality:</b> '.$app['nationality'].'</td>
    </tr>
    <tr>
        <td><b>Date of Birth:</b> '.$app['dob'].'</td>
        <td><b>Aadhar No:</b> '.$app['aadhar_child'].'</td>
    </tr>
    <tr>
        <td colspan="2"><b>Residential Address:</b> '.$app['res_address'].'</td>
    </tr>
    <tr>
        <td colspan="2"><b>Last School Attended:</b> '.$app['last_school'].'</td>
    </tr>
</table>



<!-- ================================
         FATHER DETAILS
================================= -->
<div class="section-title">Father Details</div>
<table class="table">
    <tr>
        <td><b>Name:</b> '.$app['father_name'].'</td>
        <td><b>Aadhar:</b> '.$app['father_aadhar'].'</td>
    </tr>
    <tr>
        <td><b>Phone:</b> '.$app['father_phone'].'</td>
        <td><b>Education:</b> '.$app['father_edu'].'</td>
    </tr>
    <tr>
        <td><b>Occupation:</b> '.$app['father_occ'].'</td>
        <td><b>Designation:</b> '.$app['father_desig'].'</td>
    </tr>
    <tr>
        <td colspan="2"><b>Organization:</b> '.$app['father_org'].'</td>
    </tr>
    <tr>
        <td colspan="2"><b>Org Address:</b> '.$app['father_org_addr'].'</td>
    </tr>
</table>



<!-- ================================
         MOTHER DETAILS
================================= -->
<div class="section-title">Mother Details</div>
<table class="table">
    <tr>
        <td><b>Name:</b> '.$app['mother_name'].'</td>
        <td><b>Aadhar:</b> '.$app['mother_aadhar'].'</td>
    </tr>
    <tr>
        <td><b>Phone:</b> '.$app['mother_phone'].'</td>
        <td><b>Education:</b> '.$app['mother_edu'].'</td>
    </tr>
    <tr>
        <td><b>Occupation:</b> '.$app['mother_occ'].'</td>
        <td><b>Designation:</b> '.$app['mother_desig'].'</td>
    </tr>
    <tr>
        <td colspan="2"><b>Organization:</b> '.$app['mother_org'].'</td>
    </tr>
    <tr>
        <td colspan="2"><b>Org Address:</b> '.$app['mother_org_addr'].'</td>
    </tr>
</table>



<!-- ================================
         MEDICAL / OTHER DETAILS
================================= -->
<div class="section-title">Medical & Other Information</div>
<table class="table">
    <tr>
        <td><b>Medical Need:</b> '.$app['medical_need'].'</td>
        <td><b>Category:</b> '.$app['category'].'</td>
    </tr>
    <tr>
        <td colspan="2"><b>Medical Details:</b> '.$app['medical_details'].'</td>
    </tr>
    <tr>
        <td><b>Transfer Info:</b> '.$app['transfer_info'].'</td>
        <td><b>Transport Required:</b> '.$app['transport_req'].'</td>
    </tr>
    <tr>
        <td><b>Sibling Name:</b> '.$app['sibling_name'].'</td>
        <td><b>Sibling Class:</b> '.$app['sibling_class'].'</td>
    </tr>
</table>



<!-- ================================
         SIGNATURES
================================= -->
<div class="section-title">Signatures</div>
<table class="table">
    <tr>
        <td>
            <b>Mother Signature</b><br>
            <img class="signature" src="'.base64img($app['sign_mother']).'">
        </td>
        <td>
            <b>Father Signature</b><br>
            <img class="signature" src="'.base64img($app['sign_father']).'">
        </td>
    </tr>
</table>

</body>
</html>
';


/* -----------------------------
   RENDER PDF
------------------------------*/

$options = new Options();
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper("A4", "portrait");
$dompdf->render();

$dompdf->stream("Admission_Form_".$id.".pdf", ["Attachment" => false]);
exit;
?>
