/* ------------------------------------------------------------
   MULTI-STEP FORM + VALIDATION + SAVE & RESUME + AJAX SUBMIT
-------------------------------------------------------------*/

// STEP CONTROL
let currentStep = 1;
const totalSteps = 3;

/* -----------------------
   Show Selected Step
------------------------*/
function showStep(step) {
    document.querySelectorAll(".form-step").forEach(s => s.classList.remove("active"));
    document.querySelector(`.form-step[data-step="${step}"]`).classList.add("active");

    document.querySelectorAll(".progress-step").forEach((p, index) => {
        p.classList.toggle("active", index < step);
    });

    window.scrollTo({ top: 0, behavior: "smooth" });
}

/* -----------------------
   Step Validation
------------------------*/
function validateStep(step) {
    const section = document.querySelector(`.form-step[data-step="${step}"]`);
    let valid = true;

    section.querySelectorAll("input, select").forEach(field => {
        field.classList.remove("error");

        if (field.hasAttribute("required") && !field.value.trim()) {
            valid = false;
            field.classList.add("error");
        }

        // Aadhar
        if (field.name.includes("aadhar") && field.value.trim() !== "") {
            if (!/^\d{12}$/.test(field.value.trim())) {
                valid = false;
                field.classList.add("error");
            }
        }

        // Phone
        if (field.name.includes("phone") && field.value.trim() !== "") {
            if (!/^\d{10}$/.test(field.value.trim())) {
                valid = false;
                field.classList.add("error");
            }
        }

        // FILE VALIDATION
        if (field.type === "file" && field.files.length > 0) {
            const file = field.files[0];
            if (file.size > 2 * 1024 * 1024) { // 2MB
                valid = false;
                field.classList.add("error");
                alert("File too large: " + field.name);
            }
        }
    });

    return valid;
}

/* -----------------------
   Next Step
------------------------*/
function nextStep() {
    if (!validateStep(currentStep)) {
        alert("Please fix errors before continuing.");
        return;
    }
    if (currentStep < totalSteps) currentStep++;
    showStep(currentStep);
}

/* -----------------------
   Previous Step
------------------------*/
function prevStep() {
    if (currentStep > 1) currentStep--;
    showStep(currentStep);
}

/* ------------------------------------------------------------
   SAVE & RESUME LATER (LOCAL STORAGE)
-------------------------------------------------------------*/
function saveProgress(step) {
    const formData = new FormData(document.getElementById("multiStepForm"));
    let saveObj = {};

    formData.forEach((value, key) => {
        if (value instanceof File) return; // skip files
        saveObj[key] = value;
    });

    localStorage.setItem("admission_form_step" + step, JSON.stringify(saveObj));
    alert("Saved successfully. You can resume later.");
}

function loadSavedData() {
    [1, 2, 3].forEach(step => {
        const saved = localStorage.getItem("admission_form_step" + step);
        if (saved) {
            const data = JSON.parse(saved);
            for (let key in data) {
                const field = document.querySelector(`[name="${key}"]`);
                if (field) field.value = data[key];
            }
        }
    });
}

window.onload = loadSavedData;

/* ------------------------------------------------------------
   FORM SUBMIT (AJAX TO PHP)
-------------------------------------------------------------*/
document.getElementById("multiStepForm").addEventListener("submit", function (e) {
    e.preventDefault();

    if (!validateStep(3)) {
        alert("Please fix errors before submitting.");
        return;
    }

    const form = document.getElementById("multiStepForm");
    const formData = new FormData(form);

    document.getElementById("statusMessage").innerHTML =
        "<span style='color: blue;'>Submitting... Please wait...</span>";

    fetch("submit.php", {
        method: "POST",
        body: formData
    })
        .then(res => res.json())
        .then(data => {
            if (data.status === "success") {
                document.getElementById("statusMessage").innerHTML =
                    "<span style='color: green;'>Application Submitted Successfully! Application ID: " + data.id + "</span>";

                // Clear saved data
                localStorage.removeItem("admission_form_step1");
                localStorage.removeItem("admission_form_step2");
                localStorage.removeItem("admission_form_step3");

                form.reset();
                showStep(1);
                
                setTimeout(() => {
                    window.location.href = "export_pdf.php?id=" + data.id;
                }, 2000);
                
                
            } else {
                document.getElementById("statusMessage").innerHTML =
                    "<span style='color: red;'>Error: " + data.message + "</span>";
            }
        })
        .catch(err => {
            document.getElementById("statusMessage").innerHTML =
                "<span style='color: red;'>Network Error! Try again.</span>";
        });
});

/* ------------------------------------------------------------
   BIND SAVE BUTTONS
-------------------------------------------------------------*/
document.getElementById("saveStep1").onclick = () => saveProgress(1);
document.getElementById("saveStep2").onclick = () => saveProgress(2);
document.getElementById("saveStep3").onclick = () => saveProgress(3);
