<?php
header("Content-Type: application/json");
error_reporting(0);

/* -----------------------------
   DATABASE CONNECTION (PDO)
------------------------------*/
    
$host = "localhost";
$db   = "admission_delhi";
$user = "admission_delhi_user";   // change if needed
$pass = "5AXobQM;ND0gTVwW";       // change if needed

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => "DB Connection Failed"]);
    exit;
}

/* -----------------------------
   FILE UPLOAD FUNCTION
------------------------------*/

function uploadFile($fileKey, $folder) {
    if (!isset($_FILES[$fileKey]) || $_FILES[$fileKey]['error'] != 0) {
        return null;
    }

    $allowed = ["jpg","jpeg","png","webp"];
    $ext = strtolower(pathinfo($_FILES[$fileKey]['name'], PATHINFO_EXTENSION));

    if (!in_array($ext, $allowed)) {
        return null;
    }

    $newName = $folder . "/" . uniqid() . "_" . time() . "." . $ext;
    $uploadPath = __DIR__ . "/" . $newName;

    if (!file_exists(__DIR__ . "/" . $folder)) {
        mkdir(__DIR__ . "/" . $folder, 0777, true);
    }

    if (move_uploaded_file($_FILES[$fileKey]["tmp_name"], $uploadPath)) {
        return $newName;
    }

    return null;
}

/* -----------------------------
   UPLOAD FILES
------------------------------*/

// Photos
$photo_child  = uploadFile("photo_child", "uploads/photos");
$photo_father = uploadFile("photo_father", "uploads/photos");
$photo_mother = uploadFile("photo_mother", "uploads/photos");

// Signatures
$sign_mother  = uploadFile("sign_mother", "uploads/signatures");
$sign_father  = uploadFile("sign_father", "uploads/signatures");

/* -----------------------------
   COLLECT FORM DATA
------------------------------*/

$data = [
    "class_sought"   => $_POST["class_sought"] ?? null,
    "reg_no"         => $_POST["reg_no"] ?? null,
    "child_name"     => $_POST["child_name"] ?? null,
    "gender"         => $_POST["gender"] ?? null,
    "nationality"    => $_POST["nationality"] ?? null,
    "dob"            => $_POST["dob"] ?? null,
    "aadhar_child"   => $_POST["aadhar_child"] ?? null,
    "res_address"    => $_POST["res_address"] ?? null,
    "last_school"    => $_POST["last_school"] ?? null,
    "email"          => $_POST["email"] ?? null,

    // Father
    "father_name"      => $_POST["father_name"] ?? null,
    "father_aadhar"    => $_POST["father_aadhar"] ?? null,
    "father_phone"     => $_POST["father_phone"] ?? null,
    "father_edu"       => $_POST["father_edu"] ?? null,
    "father_occ"       => $_POST["father_occ"] ?? null,
    "father_desig"     => $_POST["father_desig"] ?? null,
    "father_org"       => $_POST["father_org"] ?? null,
    "father_org_addr"  => $_POST["father_org_addr"] ?? null,

    // Mother
    "mother_name"      => $_POST["mother_name"] ?? null,
    "mother_aadhar"    => $_POST["mother_aadhar"] ?? null,
    "mother_phone"     => $_POST["mother_phone"] ?? null,
    "mother_edu"       => $_POST["mother_edu"] ?? null,
    "mother_occ"       => $_POST["mother_occ"] ?? null,
    "mother_desig"     => $_POST["mother_desig"] ?? null,
    "mother_org"       => $_POST["mother_org"] ?? null,
    "mother_org_addr"  => $_POST["mother_org_addr"] ?? null,

    "single_parent"   => $_POST["single_parent"] ?? null,

    // Step 3
    "sibling_name"    => $_POST["sibling_name"] ?? null,
    "sibling_class"   => $_POST["sibling_class"] ?? null,
    "medical_need"    => $_POST["medical_need"] ?? null,
    "medical_details" => $_POST["medical_details"] ?? null,
    "transfer_info"   => $_POST["transfer_info"] ?? null,
    "transport_req"   => $_POST["transport_req"] ?? null,
    "category"        => $_POST["category"] ?? null,
];

/* -----------------------------
   INSERT DATA INTO DATABASE
------------------------------*/

try {

    $sql = "INSERT INTO applications (
        photo_child, photo_father, photo_mother,
        class_sought, reg_no, child_name, gender, nationality,
        dob, aadhar_child, res_address, last_school, email,
        father_name, father_aadhar, father_phone, father_edu, father_occ,
        father_desig, father_org, father_org_addr,
        mother_name, mother_aadhar, mother_phone, mother_edu, mother_occ,
        mother_desig, mother_org, mother_org_addr,
        single_parent, sibling_name, sibling_class,
        medical_need, medical_details, transfer_info, transport_req, category,
        sign_mother, sign_father
    ) VALUES (
        :photo_child, :photo_father, :photo_mother,
        :class_sought, :reg_no, :child_name, :gender, :nationality,
        :dob, :aadhar_child, :res_address, :last_school, :email,
        :father_name, :father_aadhar, :father_phone, :father_edu, :father_occ,
        :father_desig, :father_org, :father_org_addr,
        :mother_name, :mother_aadhar, :mother_phone, :mother_edu, :mother_occ,
        :mother_desig, :mother_org, :mother_org_addr,
        :single_parent, :sibling_name, :sibling_class,
        :medical_need, :medical_details, :transfer_info, :transport_req, :category,
        :sign_mother, :sign_father
    )";

    $stmt = $pdo->prepare($sql);

    $stmt->execute([
        ":photo_child"   => $photo_child,
        ":photo_father"  => $photo_father,
        ":photo_mother"  => $photo_mother,

        ":class_sought"  => $data["class_sought"],
        ":reg_no"        => $data["reg_no"],
        ":child_name"    => $data["child_name"],
        ":gender"        => $data["gender"],
        ":nationality"   => $data["nationality"],
        ":dob"           => $data["dob"],
        ":aadhar_child"  => $data["aadhar_child"],
        ":res_address"   => $data["res_address"],
        ":last_school"   => $data["last_school"],
        ":email"         => $data["email"],

        ":father_name"    => $data["father_name"],
        ":father_aadhar"  => $data["father_aadhar"],
        ":father_phone"   => $data["father_phone"],
        ":father_edu"     => $data["father_edu"],
        ":father_occ"     => $data["father_occ"],
        ":father_desig"   => $data["father_desig"],
        ":father_org"     => $data["father_org"],
        ":father_org_addr"=> $data["father_org_addr"],

        ":mother_name"    => $data["mother_name"],
        ":mother_aadhar"  => $data["mother_aadhar"],
        ":mother_phone"   => $data["mother_phone"],
        ":mother_edu"     => $data["mother_edu"],
        ":mother_occ"     => $data["mother_occ"],
        ":mother_desig"   => $data["mother_desig"],
        ":mother_org"     => $data["mother_org"],
        ":mother_org_addr"=> $data["mother_org_addr"],

        ":single_parent"  => $data["single_parent"],

        ":sibling_name"   => $data["sibling_name"],
        ":sibling_class"  => $data["sibling_class"],
        ":medical_need"   => $data["medical_need"],
        ":medical_details"=> $data["medical_details"],
        ":transfer_info"  => $data["transfer_info"],
        ":transport_req"  => $data["transport_req"],
        ":category"       => $data["category"],

        ":sign_mother"    => $sign_mother,
        ":sign_father"    => $sign_father,
    ]);

   // ★ GET LAST INSERTED ID
    $last_id = $pdo->lastInsertId();

    echo json_encode([
        "status" => "success",
        "id" => $last_id,
        "message" => "Form Submitted Successfully"
    ]);


} catch (Exception $e) {

    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}

?>
